// This comes with no warranty, implied or otherwise

// This data structure was designed to support Proportional fonts
// on Arduinos. It can however handle any ttf font that has been converted
// using the conversion program. These could be fixed width or proportional
// fonts. Individual characters do not have to be multiples of 8 bits wide.
// Any width is fine and does not need to be fixed.

// The data bits are packed to minimize data requirements, but the tradeoff
// is that a header is required per character.

// calibri_bold_20.c
// Point Size   : 20
// Memory usage : 2016 bytes
// # characters : 95

// Header Format (to make Arduino UTFT Compatible):
// ------------------------------------------------
// Character Width (Used as a marker to indicate use this format. i.e.: = 0x00)
// Character Height
// First Character (Reserved. 0x00)
// Number Of Characters (Reserved. 0x00)

#include <avr/pgmspace.h>

uint8_t calibri_bold_20[] PROGMEM =
{
0x00, 0x13, 0x00, 0x00,

// Individual Character Format:
// ----------------------------
// Character Code
// Adjusted Y Offset
// Width
// Height
// xOffset
// xDelta (the distance to move the cursor. Effective width of the character.)
// Data[n]

// NOTE: You can remove any of these characters if they are not needed in
// your application. The first character number in each Glyph indicates
// the ASCII character code. Therefore, these do not have to be sequential.
// Just remove all the content for a particular character to save space.

// ' '
0x20,0x0F,0x00,0x00,0x00,0x05,

// '!'
0x21,0x01,0x03,0x0F,0x02,0x07,
0x5F,0xFF,0xFF,0x6C,0x2F,0xC0,
// '"'
0x22,0x01,0x07,0x06,0x01,0x09,
0x4D,0x9B,0x36,0x6C,0xC0,0x00,
// '#'
0x23,0x02,0x0A,0x0E,0x00,0x0A,
0x11,0x06,0x63,0x10,0xEE,0x7F,0xCC,0xC3,0x30,0xCC,0xFF,0x9F,0xE6,0x31,0x98,0x66,0x00,0x00,
// '$'
0x24,0x00,0x0A,0x12,0x00,0x0A,
0x04,0x01,0x00,0xE0,0xFC,0x71,0x1C,0x07,0x01,0xF0,0x3F,0x03,0xE0,0x38,0x0E,0x43,0x9F,0xC3,0xE0,0x60,0x18,0x00,0x00,
// '%'
0x25,0x02,0x0F,0x0E,0x00,0x0F,
0x00,0x18,0xF8,0x61,0xB0,0xC2,0x63,0x04,0xCC,0x0D,0xB0,0x1E,0x60,0x01,0xBE,0x06,0x6C,0x1C,0x98,0x31,0x30,0xC3,0x63,0x07,0x80,0x00,0x00,
// '&'
0x26,0x01,0x0E,0x0F,0x00,0x0E,
0x00,0x00,0x7E,0x03,0xFC,0x0E,0x70,0x39,0xC0,0xEE,0x01,0xF0,0x07,0x8C,0x3F,0x31,0xCE,0xC7,0x1F,0x1C,0x3C,0x7F,0xF8,0x7E,0x60,0x00,0x00,
// '''
0x27,0x01,0x03,0x06,0x01,0x05,
0x5B,0x6C,0x00,
// '('
0x28,0x01,0x05,0x12,0x01,0x06,
0x31,0x9C,0xC6,0x73,0x9C,0xE7,0x39,0xCE,0x31,0x8E,0x30,0x00,
// ')'
0x29,0x01,0x06,0x12,0x00,0x06,
0x61,0xC3,0x0C,0x38,0xE1,0x86,0x18,0x61,0x8E,0x38,0xE3,0x1C,0x60,0x00,
// '*'
0x2A,0x01,0x08,0x08,0x01,0x0A,
0x18,0x1A,0xFE,0x3C,0x7E,0xFE,0x18,0x18,
// '+'
0x2B,0x04,0x0A,0x0B,0x00,0x0A,
0x00,0x03,0x00,0xC0,0x30,0x7F,0x9F,0xE0,0xC0,0x30,0x0C,0x03,0x00,0x00,
// ','
0x2C,0x0C,0x05,0x06,0x00,0x05,
0x33,0x9C,0xC6,0x60,
// '-'
0x2D,0x09,0x06,0x03,0x00,0x06,
0x79,0xE0,0x00,
// '.'
0x2E,0x0C,0x04,0x04,0x01,0x05,
0x6E,0xE0,
// '/'
0x2F,0x00,0x09,0x12,0x00,0x09,
0x00,0x01,0x81,0xC0,0xC0,0x60,0x70,0x30,0x18,0x1C,0x0C,0x06,0x07,0x03,0x03,0x81,0xC0,0xC0,0xE0,0x60,0x00,
// '0'
0x30,0x02,0x0A,0x0E,0x00,0x0A,
0x1E,0x0F,0xC7,0x39,0x86,0x61,0x98,0x76,0x1D,0x87,0x61,0x98,0x67,0x39,0xFC,0x3E,0x00,0x00,
// '1'
0x31,0x02,0x09,0x0D,0x01,0x0A,
0x1C,0x1E,0x1F,0x1B,0x81,0xC0,0xE0,0x70,0x38,0x1C,0x0E,0x07,0x0F,0xE7,0xF0,
// '2'
0x32,0x02,0x0A,0x0D,0x00,0x0A,
0x1E,0x1F,0xC7,0xF8,0x0E,0x03,0x81,0xC0,0x70,0x38,0x1C,0x0E,0x07,0x01,0xFE,0x7F,0x80,
// '3'
0x33,0x02,0x0A,0x0E,0x00,0x0A,
0x1E,0x1F,0xC6,0x78,0x0E,0x03,0x03,0xC3,0xE0,0x3E,0x03,0x80,0xE0,0x39,0xFE,0x7E,0x00,0x00,
// '4'
0x34,0x02,0x0A,0x0E,0x00,0x0A,
0x07,0x03,0xC0,0xF0,0x6C,0x3B,0x0C,0xC6,0x31,0x8C,0xFF,0xBF,0xF0,0x78,0x0C,0x03,0x00,0x00,
// '5'
0x35,0x02,0x0A,0x0E,0x00,0x0A,
0x3F,0x1F,0xC7,0xF1,0xC0,0x70,0x1F,0x87,0xF0,0x0E,0x03,0x80,0xE0,0x39,0xFC,0x7E,0x00,0x00,
// '6'
0x36,0x02,0x0A,0x0E,0x00,0x0A,
0x0F,0x07,0xE3,0x81,0xC0,0x60,0x1F,0xC7,0xF9,0xC6,0x61,0x9C,0x67,0x18,0xFE,0x1F,0x00,0x00,
// '7'
0x37,0x02,0x0A,0x0E,0x00,0x0A,
0x7F,0x9F,0xE7,0xF8,0x0E,0x03,0x01,0xC0,0x70,0x38,0x0E,0x07,0x01,0xC0,0xE0,0x38,0x00,0x00,
// '8'
0x38,0x02,0x0A,0x0E,0x00,0x0A,
0x1E,0x0F,0xE7,0x39,0x86,0x73,0x8F,0xC1,0xE0,0xFE,0x73,0x98,0x66,0x19,0xFE,0x3F,0x00,0x00,
// '9'
0x39,0x02,0x0A,0x0E,0x00,0x0A,
0x1E,0x0F,0xC7,0x39,0x86,0x61,0x98,0x67,0xF8,0xFE,0x01,0x80,0xE0,0x39,0xFC,0x7E,0x00,0x00,
// ':'
0x3A,0x05,0x04,0x0B,0x01,0x06,
0x06,0x66,0x00,0x06,0x66,0x00,
// ';'
0x3B,0x05,0x05,0x0D,0x00,0x06,
0x01,0x8C,0x60,0x00,0x06,0x31,0x9C,0xC4,0x00,
// '<'
0x3C,0x04,0x09,0x0B,0x00,0x0A,
0x00,0x00,0xC1,0xE3,0xC7,0x83,0x81,0xE0,0x3E,0x07,0x80,0xC0,0x00,
// '='
0x3D,0x06,0x0A,0x07,0x00,0x0A,
0x7F,0x1F,0xE0,0x00,0x00,0x7F,0x9F,0xE0,0x00,
// '>'
0x3E,0x04,0x09,0x0B,0x01,0x0A,
0x00,0x60,0x3C,0x07,0x80,0xF0,0x38,0x3C,0xF8,0xF0,0x60,0x00,0x00,
// '?'
0x3F,0x01,0x08,0x0F,0x01,0x09,
0x00,0xFC,0xDE,0x06,0x06,0x06,0x1E,0x3C,0x30,0x30,0x00,0x30,0x38,0x30,0x00,
// '@'
0x40,0x01,0x11,0x11,0x00,0x12,
0x00,0x00,0x00,0xFC,0x01,0xFF,0x81,0xC0,0xE1,0x88,0x31,0xDF,0xDC,0xCD,0xCE,0x6C,0x67,0x66,0x33,0x33,0x19,0x99,0x9D,0xCC,0xFF,0xC7,0x00,0x81,0x80,0x00,0xF8,0xC0,0x1F,0xE0,0x00,0x00,0x00,
// 'A'
0x41,0x02,0x0C,0x0E,0x00,0x0C,
0x06,0x00,0xF0,0x0F,0x01,0xF8,0x1B,0x81,0x98,0x39,0xC3,0x0C,0x3F,0xC7,0xFE,0x60,0xE6,0x07,0xE0,0x70,0x00,
// 'B'
0x42,0x02,0x0A,0x0D,0x01,0x0B,
0x7C,0x3F,0xCE,0x7B,0x8E,0xE3,0xB9,0xCF,0xF3,0x9E,0xE1,0xB8,0x6E,0x3B,0xFE,0x7E,0x00,
// 'C'
0x43,0x02,0x0B,0x0E,0x00,0x0B,
0x07,0x83,0xF8,0xF3,0x38,0x07,0x00,0xE0,0x1C,0x03,0x80,0x70,0x0E,0x00,0xE1,0x1F,0xE1,0xF8,0x00,0x00,
// 'D'
0x44,0x02,0x0B,0x0D,0x01,0x0D,
0x7C,0x1F,0xF3,0x9F,0x70,0xEE,0x0F,0xC1,0xF8,0x3F,0x07,0xE0,0xFC,0x3B,0x8F,0x7F,0xC7,0xE0,
// 'E'
0x45,0x02,0x08,0x0D,0x01,0x0A,
0x7E,0xFF,0xE0,0xE0,0xE0,0xFE,0xFE,0xE0,0xE0,0xE0,0xE0,0xFF,0x7F,
// 'F'
0x46,0x02,0x08,0x0E,0x01,0x09,
0x7E,0xFE,0xE0,0xE0,0xE0,0xE0,0xFE,0xFE,0xE0,0xE0,0xE0,0xE0,0xE0,0x00,
// 'G'
0x47,0x02,0x0C,0x0E,0x00,0x0D,
0x07,0xC1,0xFE,0x3C,0x67,0x00,0x70,0x06,0x00,0x63,0xE6,0x3E,0x70,0x67,0x06,0x38,0x63,0xFE,0x0F,0xE0,0x00,
// 'H'
0x48,0x02,0x0B,0x0E,0x01,0x0D,
0x60,0xDC,0x1B,0x83,0x70,0x6E,0x0D,0xFF,0xBF,0xF7,0xFE,0xE0,0xDC,0x1B,0x83,0x70,0x6E,0x0C,0x00,0x00,
// 'I'
0x49,0x02,0x03,0x0E,0x01,0x05,
0x7F,0xFF,0xFF,0xFF,0xFE,0x00,
// 'J'
0x4A,0x02,0x06,0x0E,0x00,0x07,
0x18,0x61,0x86,0x18,0x61,0x86,0x18,0x63,0xBE,0xF0,0x00,
// 'K'
0x4B,0x02,0x0A,0x0E,0x01,0x0B,
0x61,0xB8,0xEE,0x73,0x9C,0xEE,0x3F,0x0F,0xC3,0xB0,0xEE,0x39,0xCE,0x73,0x8E,0xE1,0x80,0x00,
// 'L'
0x4C,0x02,0x08,0x0D,0x01,0x08,
0x60,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xFE,0x7E,
// 'M'
0x4D,0x02,0x10,0x0E,0x01,0x11,
0x70,0x0E,0xF8,0x1E,0xF8,0x3E,0xFC,0x3E,0xEC,0x36,0xEC,0x76,0xEE,0x66,0xE6,0xE6,0xE6,0xC6,0xE7,0xC6,0xE3,0xC6,0xE3,0x86,0xE3,0x86,0x00,0x00,
// 'N'
0x4E,0x02,0x0B,0x0E,0x01,0x0D,
0x60,0x5E,0x1F,0xE3,0xFC,0x7F,0xCF,0xDD,0xFB,0xBF,0x3F,0xE7,0xFC,0x7F,0x8F,0xF0,0xFE,0x0E,0x00,0x00,
// 'O'
0x4F,0x02,0x0D,0x0E,0x00,0x0E,
0x07,0x80,0xFF,0x0F,0x3C,0xE0,0xE7,0x03,0xB8,0x1D,0xC0,0xEE,0x07,0x70,0x3B,0x83,0x9E,0x1C,0x7F,0xC1,0xFC,0x00,0x00,
// 'P'
0x50,0x02,0x0A,0x0E,0x01,0x0B,
0x7C,0x3F,0xCE,0x7B,0x8E,0xE3,0xB8,0xEE,0x73,0xFC,0xF8,0x38,0x0E,0x03,0x80,0xE0,0x00,0x00,
// 'Q'
0x51,0x02,0x0E,0x10,0x00,0x0E,
0x07,0x80,0x7F,0x83,0xCF,0x1C,0x1C,0x70,0x39,0xC0,0xE7,0x03,0x9C,0x0E,0x70,0x39,0xC1,0xC7,0x87,0x0F,0xF8,0x1F,0xF0,0x00,0xF0,0x01,0xC0,0x00,
// 'R'
0x52,0x02,0x0A,0x0E,0x01,0x0B,
0x7C,0x3F,0xCE,0x7B,0x8E,0xE3,0xB8,0xEF,0xF3,0xF8,0xE7,0x38,0xCE,0x3B,0x86,0xE1,0xC0,0x00,
// 'S'
0x53,0x02,0x09,0x0E,0x00,0x09,
0x1E,0x1F,0x9C,0x4C,0x07,0x03,0xE0,0xF8,0x1E,0x03,0x81,0xD0,0xEF,0xE7,0xE0,0x00,
// 'T'
0x54,0x02,0x0A,0x0E,0x00,0x0A,
0x7F,0xBF,0xF1,0xE0,0x30,0x0C,0x03,0x00,0xC0,0x30,0x0C,0x03,0x00,0xC0,0x30,0x0C,0x00,0x00,
// 'U'
0x55,0x02,0x0B,0x0E,0x01,0x0D,
0x60,0xDC,0x1F,0x83,0xF0,0x7E,0x0F,0xC1,0xF8,0x3F,0x07,0xE0,0xFC,0x1D,0xC7,0x3F,0xE3,0xF8,0x00,0x00,
// 'V'
0x56,0x02,0x0C,0x0E,0x00,0x0C,
0x60,0x6E,0x06,0x60,0x67,0x0E,0x70,0xC3,0x0C,0x39,0xC3,0x98,0x19,0x81,0xF8,0x1F,0x00,0xF0,0x0F,0x00,0x00,
// 'W'
0x57,0x02,0x12,0x0E,0x00,0x12,
0x60,0xC0,0x98,0x78,0x76,0x1E,0x19,0xC7,0x86,0x71,0xE3,0x8C,0x7C,0xC3,0x33,0x30,0xEC,0xCC,0x3B,0x37,0x07,0xCF,0x81,0xE1,0xE0,0x78,0x78,0x0E,0x1E,0x00,0x00,0x00,
// 'X'
0x58,0x02,0x0B,0x0E,0x00,0x0B,
0x60,0xCE,0x39,0xC7,0x1D,0xC1,0xF0,0x3E,0x03,0xC0,0xF8,0x1F,0x07,0x71,0xC7,0x38,0xEE,0x0E,0x00,0x00,
// 'Y'
0x59,0x02,0x0B,0x0E,0x00,0x0A,
0x60,0xCC,0x39,0xC6,0x19,0xC3,0xB0,0x3E,0x07,0x80,0x70,0x0C,0x01,0x80,0x30,0x06,0x00,0xC0,0x00,0x00,
// 'Z'
0x5A,0x02,0x0A,0x0D,0x00,0x0A,
0x7F,0x1F,0xE0,0x78,0x1C,0x07,0x03,0x81,0xC0,0x70,0x38,0x1C,0x07,0x01,0xFE,0x7F,0x80,
// '['
0x5B,0x01,0x05,0x12,0x01,0x07,
0x73,0xD8,0xC6,0x31,0x8C,0x63,0x18,0xC6,0x31,0x8C,0x78,0x00,
// '\'
0x5C,0x00,0x09,0x12,0x00,0x09,
0x00,0x70,0x18,0x0E,0x07,0x01,0x80,0xE0,0x30,0x18,0x0E,0x03,0x01,0x80,0xE0,0x30,0x1C,0x0E,0x03,0x01,0x80,
// ']'
0x5D,0x01,0x05,0x12,0x00,0x07,
0x7B,0xC6,0x31,0x8C,0x63,0x18,0xC6,0x31,0x8C,0x67,0x78,0x00,
// '^'
0x5E,0x02,0x0A,0x09,0x00,0x0A,
0x0C,0x07,0x81,0xE0,0xDC,0x33,0x1C,0xE6,0x1B,0x86,0x00,0x00,
// '_'
0x5F,0x10,0x0C,0x03,0xFF,0x0A,
0x00,0x07,0xFE,0x7F,0xE0,
// '`'
0x60,0x01,0x06,0x05,0x00,0x06,
0x60,0xC1,0x80,0x00,
// 'a'
0x61,0x05,0x09,0x0B,0x00,0x0A,
0x0C,0x3F,0x98,0xC0,0x70,0xFB,0xFD,0xCE,0xC7,0x7F,0x9F,0xC0,0x00,
// 'b'
0x62,0x01,0x09,0x0F,0x01,0x0B,
0x40,0x70,0x38,0x1C,0x0E,0x47,0xFB,0xFD,0xC7,0xE3,0xF1,0xF8,0xFC,0x7F,0xF6,0xF0,0x00,
// 'c'
0x63,0x05,0x08,0x0B,0x00,0x08,
0x0C,0x3F,0x7B,0x70,0x60,0x60,0x60,0x71,0x7F,0x3E,0x00,
// 'd'
0x64,0x01,0x0A,0x0F,0x00,0x0B,
0x00,0x80,0x70,0x1C,0x07,0x09,0xCF,0xF7,0xFD,0xC7,0x61,0xD8,0x76,0x1D,0xCF,0x7F,0xCF,0x60,0x00,
// 'e'
0x65,0x05,0x0A,0x0B,0x00,0x0A,
0x0C,0x0F,0xC7,0x39,0x86,0x7F,0x9F,0xE6,0x01,0xC0,0x7F,0x8F,0xE0,0x00,
// 'f'
0x66,0x01,0x07,0x0F,0x00,0x06,
0x0C,0x78,0xE1,0x87,0x1F,0x9F,0x18,0x30,0x60,0xC1,0x83,0x06,0x00,0x00,
// 'g'
0x67,0x05,0x0A,0x0E,0x00,0x09,
0x08,0x0F,0xE7,0x71,0x8C,0x63,0x1F,0x87,0xC1,0x80,0x7F,0x1F,0xEE,0x3B,0x8E,0x7F,0x06,0x00,
// 'h'
0x68,0x01,0x09,0x0F,0x01,0x0B,
0x40,0x70,0x38,0x1C,0x0E,0x47,0xFB,0xFD,0xC6,0xE3,0xF1,0xF8,0xFC,0x7E,0x3F,0x1C,0x00,
// 'i'
0x69,0x01,0x03,0x0F,0x01,0x05,
0x1F,0x81,0xFF,0xFF,0xFF,0xC0,
// 'j'
0x6A,0x01,0x06,0x12,0xFF,0x05,
0x00,0xE3,0x80,0x00,0xE3,0x8E,0x38,0xE3,0x8E,0x38,0xE3,0x9E,0x71,0x00,
// 'k'
0x6B,0x01,0x09,0x0F,0x01,0x0A,
0x40,0x70,0x38,0x1C,0x0E,0x07,0x3B,0xB9,0xF8,0xF8,0x7E,0x3B,0x1D,0xCE,0x77,0x18,0x00,
// 'l'
0x6C,0x01,0x03,0x0F,0x01,0x05,
0x5F,0xFF,0xFF,0xFF,0xFF,0xC0,
// 'm'
0x6D,0x05,0x0F,0x0B,0x01,0x10,
0x04,0x31,0xFE,0xF3,0xFF,0xF7,0x1C,0xEE,0x30,0xDC,0x61,0xB8,0xC3,0x71,0x86,0xE3,0x0D,0xC6,0x18,0x00,0x00,
// 'n'
0x6E,0x05,0x09,0x0B,0x01,0x0B,
0x04,0x7F,0xBF,0xDC,0x6E,0x3F,0x1F,0x8F,0xC7,0xE3,0xF1,0xC0,0x00,
// 'o'
0x6F,0x05,0x0B,0x0B,0x00,0x0B,
0x0E,0x07,0xF1,0xEE,0x38,0xE6,0x1C,0xC3,0x98,0x73,0x8E,0x7F,0x83,0xE0,0x00,0x00,
// 'p'
0x70,0x05,0x09,0x0E,0x01,0x0B,
0x04,0x7F,0xBF,0xDC,0x7E,0x3F,0x1F,0x8F,0xC7,0xFF,0x7F,0x38,0x1C,0x0E,0x02,0x00,
// 'q'
0x71,0x05,0x0A,0x0E,0x00,0x0B,
0x08,0x0F,0xF7,0xFD,0xC7,0x61,0xD8,0x76,0x1D,0xCF,0x7F,0xCF,0x70,0x1C,0x07,0x01,0xC0,0x20,
// 'r'
0x72,0x05,0x06,0x0B,0x01,0x07,
0x0B,0xFF,0xF8,0xE3,0x8E,0x38,0xE3,0x80,0x00,
// 's'
0x73,0x05,0x08,0x0B,0x00,0x08,
0x08,0x7E,0x62,0x60,0x78,0x3E,0x0E,0x06,0x7E,0x7C,0x00,
// 't'
0x74,0x03,0x07,0x0D,0x00,0x07,
0x30,0x61,0xC7,0xE7,0xC6,0x0C,0x18,0x30,0x60,0xF0,0xE0,0x00,
// 'u'
0x75,0x05,0x09,0x0B,0x01,0x0B,
0x00,0x71,0xF8,0xFC,0x7E,0x3F,0x1F,0x8F,0xCF,0x7F,0xBD,0x80,0x00,
// 'v'
0x76,0x05,0x0A,0x0B,0x00,0x09,
0x00,0x38,0x66,0x39,0xCE,0x73,0x0D,0xC3,0x70,0xF8,0x1E,0x07,0x00,0x00,
// 'w'
0x77,0x05,0x0F,0x0B,0x00,0x0F,
0x00,0x01,0xC7,0x19,0x8E,0x33,0x9C,0xE7,0x7D,0xC6,0xDB,0x0F,0xB6,0x1F,0x7C,0x3C,0x70,0x38,0xE0,0x00,0x00,
// 'x'
0x78,0x05,0x09,0x0B,0x00,0x09,
0x00,0x39,0x9D,0xC7,0xC3,0xE0,0xF0,0xF8,0x6E,0x77,0x71,0xC0,0x00,
// 'y'
0x79,0x05,0x0A,0x0E,0x00,0x09,
0x00,0x38,0x66,0x39,0xCC,0x73,0x0D,0xC3,0xE0,0x78,0x1E,0x07,0x00,0xC0,0x70,0x18,0x04,0x00,
// 'z'
0x7A,0x05,0x08,0x0A,0x00,0x08,
0x00,0x7E,0x7E,0x0C,0x1C,0x38,0x30,0x70,0x7E,0x7E,
// '{'
0x7B,0x00,0x07,0x13,0x00,0x07,
0x00,0x38,0x71,0xC3,0x87,0x0E,0x18,0x70,0xC1,0xC1,0x83,0x87,0x0E,0x1C,0x1C,0x38,0x00,
// '|'
0x7C,0x00,0x03,0x13,0x03,0x0A,
0x0D,0xB6,0xDB,0x6D,0xB6,0xDB,0x6D,0x00,
// '}'
0x7D,0x00,0x06,0x13,0x01,0x07,
0x03,0x8F,0x0C,0x30,0xC3,0x0C,0x38,0x73,0x8C,0x30,0xC3,0x0C,0xF3,0x80,0x00,
// '~'
0x7E,0x03,0x0A,0x05,0x00,0x0A,
0x00,0x1E,0x27,0xF9,0x1E,0x02,0x00,

// Terminator
0xFF
};